import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples'
base_results: str = 'results'
num_sample_steps: int = 40


def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 64,
        'batch_repeats': 8,
        'data_loader_workers': 4,
        'dataset': {'dataset_name': 'afhqv2-64x64'},
        'report': {'train_steps': 50},
        'checkpoint': {
            'save_steps': 25_000,
            'last_steps': 5_000
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-afhqv2-64x64-uncond-vp',
            'load_path': 'external/edm/state_dicts/edm-afhqv2-64x64-uncond-vp.pth'
        },
        'model_optimizer': {'name': 'r-adam', 'learning_rate': 0.0001},
        'ema': [
            {'beta': 0.999, 'update_every': 1}
        ],
        'fid': {
            'steps': 25_000,
            'batch_size': 25,
            'reference_path': 'PATH/fid-refs/afhqv2-64x64.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 64}},
        'amp': {},
        'distributed_sampler_seed': int(np.random.randint(0, 2 ** 31)),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 2_000_000
                },
                'image': {
                    'folder': f'{base_data}/afhqv2-64x64/edm-afhqv2-64x64-uncond-vp',
                    'num_samples': 2_000_000
                },
                'time_step': i
            } for i in range(num_sample_steps)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 10,
                    'start_index': 2_000_000
                },
                'image': {
                    'folder': f'{base_data}/afhqv2-64x64/edm-afhqv2-64x64-uncond-vp',
                    'num_samples': 10,
                    'start_index': 2_000_000
                },
                'time_step': 0
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 50_000,
                    'start_index': 2_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
