#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1-10d97df1-8856-482a-a0eb-95fd2766d231-%j.out
#SBATCH --error=runs/errors/lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1-10d97df1-8856-482a-a0eb-95fd2766d231-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_unconditional \
  --config_filepath configs/lines-afhqv2-64x64-1-loss-lpips-vgg-64-bs-512-br-1-10d97df1-8856-482a-a0eb-95fd2766d231.json \
  --distributed \
  --retries 3
