#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-cifar10-32x32-loss-lpips-vgg-64-bs-512-br-1-0e40e654-c0cb-4355-8bbb-eca0a52f4e29-%j.out
#SBATCH --error=runs/errors/lines-cifar10-32x32-loss-lpips-vgg-64-bs-512-br-1-0e40e654-c0cb-4355-8bbb-eca0a52f4e29-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

moudle load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  --nnodes 2 \
  --node-rank 0 \
  --master-addr "silico-008" \
  --master-port 5000 \
  -m src.scripts.lines_distributed --config_filepath configs/lines-cifar10-32x32-loss-lpips-vgg-64-bs-512-br-1-0e40e654-c0cb-4355-8bbb-eca0a52f4e29.json
