#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-cifar10-32x32-3-loss-lpips-vgg-64-bs-256-br-2-3abb05ad-4158-4d0d-9edc-bcb5ca95e020-%j.out
#SBATCH --error=runs/errors/lines-cifar10-32x32-3-loss-lpips-vgg-64-bs-256-br-2-3abb05ad-4158-4d0d-9edc-bcb5ca95e020-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

moudle load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_conditional \
  --config_filepath configs/lines-cifar10-32x32-3-loss-lpips-vgg-64-bs-256-br-2-3abb05ad-4158-4d0d-9edc-bcb5ca95e020.json \
  --distributed \
  --retries 3
