import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples/cifar10-32x32'
base_results: str = 'results'
num_sample_steps: int = 18

load_path: str = 'PATH/external/edm/state_dicts/edm-cifar10-32x32-uncond-vp.pth'

def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 256,
        'batch_repeats': 2,
        'data_loader_workers': 4,
        'dataset': {'dataset_name': 'cifar10-32x32'},
        'report': {'train_steps': 100},
        'checkpoint': {
            'save_steps': 50_000,
            'last_steps': 5_000
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-cifar10-32x32-uncond-vp',
            'load_path': load_path
        },
        'model_optimizer': {'name': 'r-adam', 'learning_rate': 0.0004},
        'ema': [
            {
                'beta': 0.999,
                'update_every': 1
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'power': 0.75
            },
            {
                'beta': 0.9999,
                'update_every': 1
            },
            {
                'beta': 0.9999,
                'update_every': 1,
                'power': 0.75
            },
        ],
        'fid': {
            'steps': 15_000,
            'batch_size': 50,
            'reference_path': 'PATH/cifar10-32x32-train.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 64}},
        'amp': {},
        'distributed_sampler_seed': int(np.random.randint(0, 2 ** 31)),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-uncond-vp',
                    'num_samples': 1_000_000
                },
                'time_step': i
            } for i in range(num_sample_steps)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 10_000,
                    'start_index': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-uncond-vp',
                    'num_samples': 10_000,
                    'start_index': 1_000_000
                },
                'time_step': 0
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
