#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2-6c55b1ee-3757-43a1-a6fb-ee96f2788a61-%j.out
#SBATCH --error=runs/errors/lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2-6c55b1ee-3757-43a1-a6fb-ee96f2788a61-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

moudle load cuda
moudle load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_unconditional \
  --config_filepath configs/lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2-6c55b1ee-3757-43a1-a6fb-ee96f2788a61.json \
  --distributed \
  --retries 3
