#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-imagenet-64x64-loss-lpips-vgg-64-bs-64-br-8-aa9cc70a-8944-422c-a085-cf2e453e835a-%j.out
#SBATCH --error=runs/errors/lines-imagenet-64x64-loss-lpips-vgg-64-bs-64-br-8-aa9cc70a-8944-422c-a085-cf2e453e835a-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

moudle load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  --nnodes 2 \
  --node-rank 0 \
  --master-addr "silico-010" \
  --master-port 5000 \
  -m src.scripts.lines_distributed --config_filepath configs/lines-imagenet-64x64-loss-lpips-vgg-64-bs-64-br-8-aa9cc70a-8944-422c-a085-cf2e453e835a.json
