import json
import uuid

from utils.types import JSON

base_data: str = 'PATH/samples/imagenet-64x64'
base_results: str = 'results/lines'
num_sample_steps: int = 40
num_sample_steps_train: int = 20


def get_config(run_id: str) -> JSON:
    return {
        'log_filepath': f'{base_results}/{run_id}/log/log.log',
        'tensorboard_log_dir': f'{base_results}/{run_id}/tensorboard/logs',
        'train_steps': 100_000_000_000,
        'batch_size': 32,
        'batch_repeats': 4,
        'data_loader_workers': 4,
        'dataset': {'dataset_name': 'imagenet-64x64'},
        'report': {'train_steps': 50, 'test_steps': None},
        'checkpoint': {
            'folder': f'{base_results}/{run_id}/checkpoints',
            'save_steps': 100_000,
            'last_steps': 20_000,
            'save_time': None,
            'last_time': 6 * 60 * 60
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-imagenet-64x64-cond-adm',
            'load_path': 'external/edm/state_dicts/edm-imagenet-64x64-cond-adm.pth'
        },
        'model_optimizer': {'name': 'r-adam', 'learning_rate': 0.000008},
        'ema': [
            {
                'beta': 0.999,
                'update_every': 1
            },
            {
                'beta': 0.9999,
                'update_every': 1
            }
        ],
        'fid': {
            'steps': 20_000,
            'batch_size': 25,
            'reference_path': 'PATH/cifar10-32x32-train.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 64}},
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 4_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-imagenet-64x64-cond-adm',
                    'num_samples': 4_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 4_000_000
                },
                'time_step': i
            } for i in range(num_sample_steps_train)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 10_000,
                    'start_index': 5_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-imagenet-64x64-cond-adm',
                    'num_samples': 10_000,
                    'start_index': 5_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 10_000,
                    'start_index': 5_000_000
                },
                'time_step': 0
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 5_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 50_000,
                    'start_index': 5_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-imagenet-64x64-3-loss-lpips-vgg-64-bs-64-br-2'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
