#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-imagenet-64x64-3-loss-lpips-vgg-64-bs-64-br-2-8fd5ff45-f5db-409a-a78c-acefb5174767-%j.out
#SBATCH --error=runs/errors/lines-imagenet-64x64-3-loss-lpips-vgg-64-bs-64-br-2-8fd5ff45-f5db-409a-a78c-acefb5174767-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_distributed --config_filepath configs/lines-imagenet-64x64-3-loss-lpips-vgg-64-bs-64-br-2-8fd5ff45-f5db-409a-a78c-acefb5174767.json
