#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-imagenet-64x64-6-loss-lpips-vgg-64-bs-32-br-64-062947fa-f47d-4910-b258-cb2f44060dec-%j.out
#SBATCH --error=runs/errors/lines-imagenet-64x64-6-loss-lpips-vgg-64-bs-32-br-64-062947fa-f47d-4910-b258-cb2f44060dec-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_distributed --config_filepath configs/lines-imagenet-64x64-6-loss-lpips-vgg-64-bs-32-br-64-062947fa-f47d-4910-b258-cb2f44060dec.json
