#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-imagenet-64x64-7-loss-lpips-vgg-64-bs-32-br-64-331fc12d-80e7-4782-bb80-bab140711521-%j.out
#SBATCH --error=runs/errors/lines-imagenet-64x64-7-loss-lpips-vgg-64-bs-32-br-64-331fc12d-80e7-4782-bb80-bab140711521-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines \
  --config_filepath configs/lines-imagenet-64x64-7-loss-lpips-vgg-64-bs-32-br-64-331fc12d-80e7-4782-bb80-bab140711521.json \
  --distributed \
  --retries 3
