import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples/imagenet-64x64'
base_results: str = 'results'
num_sample_steps: int = 40
num_sample_steps_train: int = 20

base_load_path: str = 'PATH/results/lines-imagenet-64x64-8-loss-lpips-vgg-64-bs-32-br-64-daa24e43-b325-4e7a-81c2-244412bfadb2.0/checkpoints/last'


def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 32,
        'batch_repeats': 64,
        'data_loader_workers': 4,
        'validate_ddp_consistency_steps': 200,
        'dataset': {'dataset_name': 'imagenet-64x64'},
        'report': {'train_steps': 25, 'test_steps': None},
        'checkpoint': {
            'save_steps': 15_000,
            'last_steps': 1_000
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-imagenet-64x64-cond-adm',
            'load_path': f'{base_load_path}/model.pth'
        },
        'model_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.000008,
            'load_path': f'{base_load_path}/model_optimizer.pth'
        },
        'ema': [
            {
                'beta': 0.999,
                'update_every': 1,
                'load_path': f'{base_load_path}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667.pth'
            },
            {
                'beta': 0.9999,
                'update_every': 1,
                'load_path': f'{base_load_path}/ema/beta_0.9999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667.pth'
            }
        ],
        'fid': {
            'steps': 5_000,
            'batch_size': 25,
            'reference_path': 'PATH/fid-refs/imagenet-64x64.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 64}},
        'amp': {
            'use_fp16': True,
            'use_autocast': False,
            'use_gard_scaler': True
        },
        'distributed_sampler_seed': int(np.random.randint(0, 2 ** 31)),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 4_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-imagenet-64x64-cond-adm',
                    'num_samples': 4_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 4_000_000
                },
                'time_step': i
            } for i in range(num_sample_steps_train)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 10_000,
                    'start_index': 5_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-imagenet-64x64-cond-adm',
                    'num_samples': 10_000,
                    'start_index': 5_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 10_000,
                    'start_index': 5_000_000
                },
                'time_step': 0
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 5_000_000
                },
                'label': {
                    'folder': f'{base_data}/labels',
                    'num_samples': 50_000,
                    'start_index': 5_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-imagenet-64x64-9-loss-lpips-vgg-64-bs-32-br-64'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
