#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-1-bs-32-br-16-reconstruction-lambda-1.0-035a7c04-5971-4ac7-9623-748f14181c68-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-1-bs-32-br-16-reconstruction-lambda-1.0-035a7c04-5971-4ac7-9623-748f14181c68-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-afhqv2-64x64-1-bs-32-br-16-reconstruction-lambda-1.0-035a7c04-5971-4ac7-9623-748f14181c68.json \
  --distributed \
  --retries 3
