#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-2-bs-32-br-16-two-step-690733ae-26b1-4157-ac92-e7f1e5c1e132-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-2-bs-32-br-16-two-step-690733ae-26b1-4157-ac92-e7f1e5c1e132-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-afhqv2-64x64-2-bs-32-br-16-two-step-690733ae-26b1-4157-ac92-e7f1e5c1e132.json \
  --distributed \
  --retries 3
