import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples'
base_real_data: str = 'PATH/datasets'
base_results: str = 'results'
num_sample_steps: int = 40
train_steps: list[int] = [0, 1]

load_path: str = 'PATH/results/lines-gan-afhqv2-64x64-1-bs-32-br-16-a54bdffd-4d4f-4b01-82b6-124625059812.0/checkpoints/30000'


def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 32,
        'batch_repeats': 16,
        'data_loader_workers': 4,
        'validate_ddp_consistency_steps': 200,
        'dataset': {'dataset_name': 'afhqv2-64x64'},
        'report': {'train_steps': 20},
        'checkpoint': {
            'save_steps': 10_000,
            'last_steps': 1_000
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-afhqv2-64x64-uncond-vp',
            'load_path': f'{load_path}/model.pth'
        },
        'model_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.0001,
            'load_path': f'{load_path}/model_optimizer.pth'
        },
        'discriminator': {
            'discriminator_load_path': f'{load_path}/discriminator.pth',
            'discriminator_feature_extractor_load_path': f'{load_path}/discriminator_feature_extractor.pth',
            'conditional': False
        },
        'discriminator_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.002,
            'params': {'betas': (0.5, 0.9)},
            'load_path': f'{load_path}/discriminator_optimizer.pth'
        },
        'ema': [
            {
                'beta': 0.999,
                'update_every': 1,
                'load_path': f'{load_path}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667.pth'
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'power': 0.75,
                'load_path': f'{load_path}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth'
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'power': 1.0,
                'load_path': f'{load_path}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth'
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'update_after_step': 0,
                'power': 1.0,
                'start_step': 100,
                'load_path': f'{load_path}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth'
            }
        ],
        'fid': {
            'steps': 2_500,
            'batch_size': 25,
            'reference_path': 'PATH/fid-refs/afhqv2-64x64.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 224}},
        'reconstruction_lambda': 1.0,
        'amp': {},
        'distributed_sampler_seed': int(np.random.randint(0, 2 ** 31)),
        'distributed_sampler_real_seed': int(np.random.randint(0, 2 ** 31)),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 2_000_000
                },
                'image': {
                    'folder': f'{base_data}/afhqv2-64x64/edm-afhqv2-64x64-uncond-vp',
                    'num_samples': 2_000_000
                },
                'time_step': i
            } for i in train_steps
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 10,
                    'start_index': 2_000_000
                },
                'image': {
                    'folder': f'{base_data}/afhqv2-64x64/edm-afhqv2-64x64-uncond-vp',
                    'num_samples': 10,
                    'start_index': 2_000_000
                },
                'time_step': 0
            }
        ],
        'train_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/afhqv2-64x64/images',
                    'num_samples': 15803
                }
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/imagenet-64x64/noises',
                    'num_samples': 50_000,
                    'start_index': 2_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-gan-afhqv2-64x64-3-bs-32-br-16-two-step-rec-lambda-1.0'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
