#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-4-bs-32-br-16-channel-16-reconstruction-lambda-1.0-1a9bbaf3-bfc3-433c-bff2-29746c553ac8-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-4-bs-32-br-16-channel-16-reconstruction-lambda-1.0-1a9bbaf3-bfc3-433c-bff2-29746c553ac8-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-afhqv2-64x64-4-bs-32-br-16-channel-16-reconstruction-lambda-1.0-1a9bbaf3-bfc3-433c-bff2-29746c553ac8.json \
  --distributed \
  --retries 3
