#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-4-bs-32-br-16-reconstruction-lambda-1.0-317638bb-417a-4a2f-9624-875e0cf83c33-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-4-bs-32-br-16-reconstruction-lambda-1.0-317638bb-417a-4a2f-9624-875e0cf83c33-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-afhqv2-64x64-4-bs-32-br-16-reconstruction-lambda-1.0-317638bb-417a-4a2f-9624-875e0cf83c33.json \
  --distributed \
  --retries 3
