#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-0.5-gan-train-two-step-03dc73d3-d4ec-4bda-aca4-11762e1c1904-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-0.5-gan-train-two-step-03dc73d3-d4ec-4bda-aca4-11762e1c1904-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional_gan_train \
  --config_filepath configs/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-0.5-gan-train-two-step-03dc73d3-d4ec-4bda-aca4-11762e1c1904.json \
  --distributed \
  --retries 3
