#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-1.0-gan-train-two-step-2dd8a779-be8a-47c2-a8d4-d16317c330dd-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-1.0-gan-train-two-step-2dd8a779-be8a-47c2-a8d4-d16317c330dd-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional_gan_train \
  --config_filepath configs/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-1.0-gan-train-two-step-2dd8a779-be8a-47c2-a8d4-d16317c330dd.json \
  --distributed \
  --retries 3
