#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-1.0-two-step-30c7d859-8ced-412a-b102-0822bd64c440-%j.out
#SBATCH --error=runs/errors/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-1.0-two-step-30c7d859-8ced-412a-b102-0822bd64c440-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-afhqv2-64x64-5-bs-32-br-16-reconstruction-lambda-1.0-two-step-30c7d859-8ced-412a-b102-0822bd64c440.json \
  --distributed \
  --retries 3
