#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-10-bs-32-br-16-2241aaf5-4a45-4402-8668-2b7d02372317-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-10-bs-32-br-16-2241aaf5-4a45-4402-8668-2b7d02372317-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-cifar10-32x32-10-bs-32-br-16-2241aaf5-4a45-4402-8668-2b7d02372317.json \
  --distributed \
  --retries 3
