#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-11-bs-32-br-16-reconstruction-lambda-1.0-70ea9559-134c-40e8-8520-88da4d48b047-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-11-bs-32-br-16-reconstruction-lambda-1.0-70ea9559-134c-40e8-8520-88da4d48b047-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-cifar10-32x32-11-bs-32-br-16-reconstruction-lambda-1.0-70ea9559-134c-40e8-8520-88da4d48b047.json \
  --distributed \
  --retries 3
