#!/bin/bash
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-4-bs-32-br-16-middle-1-1bce19c2-10a5-45ec-929b-14c38a568caf-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-4-bs-32-br-16-middle-1-1bce19c2-10a5-45ec-929b-14c38a568caf-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan \
  --config_filepath configs/lines-gan-cifar10-32x32-4-bs-32-br-16-middle-1-1bce19c2-10a5-45ec-929b-14c38a568caf.json \
  --distributed \
  --retries 3
