#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-5-bs-32-br-16-middle-4-7d8147d6-4e3f-4f81-92b7-4926ab6de9ec-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-5-bs-32-br-16-middle-4-7d8147d6-4e3f-4f81-92b7-4926ab6de9ec-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan \
  --config_filepath configs/lines-gan-cifar10-32x32-5-bs-32-br-16-middle-4-7d8147d6-4e3f-4f81-92b7-4926ab6de9ec.json \
  --distributed \
  --retries 3
