#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-6-bs-32-br-16-ed8209ec-dd50-43dd-b3ab-e532e6200bdd-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-6-bs-32-br-16-ed8209ec-dd50-43dd-b3ab-e532e6200bdd-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan \
  --config_filepath configs/lines-gan-cifar10-32x32-6-bs-32-br-16-ed8209ec-dd50-43dd-b3ab-e532e6200bdd.json \
  --distributed \
  --retries 3
