import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples/cifar10-32x32'
base_real_data: str = 'PATH'
base_results: str = 'results'
num_sample_steps: int = 18

model_load_folder: str = 'PATH/results/lines-cifar10-32x32-uncond-3-loss-lpips-vgg-64-bs-256-br-2-417e381f-0171-451b-9dc1-c779895358c5.0/checkpoints/100000'


def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 32,
        'batch_repeats': 16,
        'data_loader_workers': 4,
        'validate_ddp_consistency_steps': 200,
        'dataset': {'dataset_name': 'cifar10-32x32'},
        'report': {'train_steps': 20},
        'checkpoint': {
            'save_steps': 10_000,
            'last_steps': 1_000
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-cifar10-32x32-uncond-vp',
            'load_path': f'{model_load_folder}/model.pth'
        },
        'model_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.0004,
            'load_path': f'{model_load_folder}/model_optimizer.pth'
        },
        'discriminator': {
            'conditional': False
        },
        'discriminator_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.002,
            'params': {'betas': (0.5, 0.9)}
        },
        'ema': [
            {
                'beta': 0.999,
                'update_every': 1,
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'power': 0.75
            },
            {
                'beta': 0.9999,
                'update_every': 1,
            },
            {
                'beta': 0.9999,
                'update_every': 1,
                'power': 0.75
            }
        ],
        'fid': {
            'steps': 2_500,
            'batch_size': 50,
            'reference_path': 'PATH/cifar10-32x32-train.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 224}},
        'reconstruction_lambda': 0.5,
        'amp': {},
        'distributed_sampler_seed': np.random.randint(0, 2 ** 31),
        'distributed_sampler_real_seed': np.random.randint(0, 2 ** 31),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-uncond-vp',
                    'num_samples': 1_000_000
                },
                'time_step': i
            } for i in range(num_sample_steps)
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-uncond-vp',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                },
                'time_step': 0
            }
        ],
        'train_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/train/images',
                    'num_samples': 50_000
                }
            }
        ],
        'test_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/test/images',
                    'num_samples': 10_000
                }
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-gan-cifar10-32x32-uncond-13-bs-32-br-16'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
