#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-uncond-13-bs-32-br-16-2fe13229-bc05-4b19-9e3e-80b1ae243470-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-uncond-13-bs-32-br-16-2fe13229-bc05-4b19-9e3e-80b1ae243470-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-cifar10-32x32-uncond-13-bs-32-br-16-2fe13229-bc05-4b19-9e3e-80b1ae243470.json \
  --distributed \
  --retries 3
