#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-uncond-14-bs-32-br-16-single-step-bc74512c-5e54-4c18-94c4-aa3e17feb4e0-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-uncond-14-bs-32-br-16-single-step-bc74512c-5e54-4c18-94c4-aa3e17feb4e0-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-cifar10-32x32-uncond-14-bs-32-br-16-single-step-bc74512c-5e54-4c18-94c4-aa3e17feb4e0.json \
  --distributed \
  --retries 3
