#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-uncond-14-bs-32-br-16-two-step-fe323e50-9576-401a-b71c-2bbf4898c980-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-uncond-14-bs-32-br-16-two-step-fe323e50-9576-401a-b71c-2bbf4898c980-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-cifar10-32x32-uncond-14-bs-32-br-16-two-step-fe323e50-9576-401a-b71c-2bbf4898c980.json \
  --distributed \
  --retries 3
