import json
import uuid

import numpy as np

from utils.types import JSON

base_data: str = 'PATH/samples/cifar10-32x32'
base_real_data: str = 'PATH'
base_results: str = 'results'
num_sample_steps: int = 18
train_steps: list[int] = [0, 1]

load_folder: str = 'PATH/results/lines-gan-cifar10-32x32-uncond-13-bs-32-br-16-83b461b5-b32e-41b3-b31c-ceb9c739fe43.0/checkpoints/last.tmp.1'


def get_config(run_id: str) -> JSON:
    return {
        'base_folder': f'{base_results}/{run_id}',
        'train_steps': 100_000_000_000,
        'batch_size': 32,
        'batch_repeats': 16,
        'data_loader_workers': 4,
        'validate_ddp_consistency_steps': 200,
        'dataset': {'dataset_name': 'cifar10-32x32'},
        'report': {'train_steps': 20},
        'checkpoint': {
            'save_steps': 10_000,
            'last_steps': 1_000
        },
        'edm_scheduler': {},
        'edm_sampler': {'num_steps': num_sample_steps},
        'model': {
            'name': 'edm-cifar10-32x32-uncond-vp',
            'load_path': f'{load_folder}/model.pth'
        },
        'model_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.0004,
            'load_path': f'{load_folder}/model_optimizer.pth'
        },
        'discriminator': {
            'discriminator_load_path': f'{load_folder}/discriminator.pth',
            'discriminator_feature_extractor_load_path': f'{load_folder}/discriminator_feature_extractor.pth',
            'conditional': False
        },
        'discriminator_optimizer': {
            'name': 'r-adam',
            'learning_rate': 0.002,
            'params': {'betas': (0.5, 0.9)},
            'load_path': f'{load_folder}/discriminator_optimizer.pth'
        },
        'ema': [
            {
                'beta': 0.999,
                'update_every': 1,
                'load_path': f'{load_folder}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.66667.pth'
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'power': 0.75,
                'load_path': f'{load_folder}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth'
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'power': 1.0,
                'load_path': f'{load_folder}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth'
            },
            {
                'beta': 0.999,
                'update_every': 1,
                'update_after_step': 0,
                'power': 1.0,
                'start_step': 100,
                'load_path': f'{load_folder}/ema/beta_0.999_update_every_1_update_after_step_100_inv_gamma_1.0_power_0.75.pth'
            }
        ],
        'fid': {
            'steps': 2_500,
            'batch_size': 50,
            'reference_path': 'PATH/cifar10-32x32-train.npz'
        },
        'reconstruction_loss': {'name': 'lpips-vgg', 'params': {'size': 224}},
        'reconstruction_lambda': 0.6,
        'amp': {},
        'distributed_sampler_seed': np.random.randint(0, 2 ** 31),
        'distributed_sampler_real_seed': np.random.randint(0, 2 ** 31),
        'train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-cond-vp',
                    'num_samples': 1_000_000
                },
                'time_step': i
            } for i in train_steps
        ],
        'test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                },
                'image': {
                    'folder': f'{base_data}/edm-cifar10-32x32-cond-vp',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                },
                'time_step': 0
            }
        ],
        'train_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/train/images',
                    'num_samples': 50_000
                }
            }
        ],
        'test_real_dataset': [
            {
                'image': {
                    'folder': f'{base_real_data}/test/images',
                    'num_samples': 10_000
                }
            }
        ],
        'fid_train_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000
                }
            }
        ],
        'fid_test_dataset': [
            {
                'noise': {
                    'folder': f'{base_data}/noises',
                    'num_samples': 50_000,
                    'start_index': 1_000_000
                }
            }
        ]
    }


def main() -> None:
    name: str = 'lines-gan-cifar10-32x32-uncond-15-bs-32-br-16-two-step-reconstruction-lambda-0.6'
    config: JSON = get_config(f'{name}-{uuid.uuid4()}')
    print(config)
    with open(f'configs/{name}-{uuid.uuid4()}.json', 'w') as file:
        json.dump(config, file)


if __name__ == '__main__':
    main()
