#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-cifar10-32x32-uncond-15-bs-32-br-16-two-step-no-load-disc-1faad7bc-f9cb-4e9a-bf86-9af725fe9ba5-%j.out
#SBATCH --error=runs/errors/lines-gan-cifar10-32x32-uncond-15-bs-32-br-16-two-step-no-load-disc-1faad7bc-f9cb-4e9a-bf86-9af725fe9ba5-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_unconditional \
  --config_filepath configs/lines-gan-cifar10-32x32-uncond-15-bs-32-br-16-two-step-no-load-disc-1faad7bc-f9cb-4e9a-bf86-9af725fe9ba5.json \
  --distributed \
  --retries 3
