#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-11-bs-16-br-32-ca0866b2-03d7-449f-bc90-c59c983b1d2b-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-11-bs-16-br-32-ca0866b2-03d7-449f-bc90-c59c983b1d2b-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-11-bs-16-br-32-ca0866b2-03d7-449f-bc90-c59c983b1d2b.json \
  --distributed \
  --retries 3
