#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-12-bs-16-br-32-reconstruction-lambda-0.4-6135a898-e4a1-410f-a724-3bbf0d59e779-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-12-bs-16-br-32-reconstruction-lambda-0.4-6135a898-e4a1-410f-a724-3bbf0d59e779-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-12-bs-16-br-32-reconstruction-lambda-0.4-6135a898-e4a1-410f-a724-3bbf0d59e779.json \
  --distributed \
  --retries 3
