#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-12-bs-16-br-32-two-step-65a6e3c2-6171-40f5-8aa4-10aa409aafd9-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-12-bs-16-br-32-two-step-65a6e3c2-6171-40f5-8aa4-10aa409aafd9-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-12-bs-16-br-32-two-step-65a6e3c2-6171-40f5-8aa4-10aa409aafd9.json \
  --distributed \
  --retries 3
