#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-14-bs-16-br-32-two-step-1f568e2f-90ff-41dd-bc2b-b29ed92c5c4c-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-14-bs-16-br-32-two-step-1f568e2f-90ff-41dd-bc2b-b29ed92c5c4c-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-14-bs-16-br-32-two-step-1f568e2f-90ff-41dd-bc2b-b29ed92c5c4c.json \
  --distributed \
  --retries 3
