#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-16-bs-8-br-64-single-step-defeddc1-07b9-464a-91a4-76dc0a6e7660-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-16-bs-8-br-64-single-step-defeddc1-07b9-464a-91a4-76dc0a6e7660-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-16-bs-8-br-64-single-step-defeddc1-07b9-464a-91a4-76dc0a6e7660.json \
  --distributed \
  --retries 3
