#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-16-bs-8-br-64-two-step-d3200ec7-ed2c-4987-9cb4-a181e7624e53-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-16-bs-8-br-64-two-step-d3200ec7-ed2c-4987-9cb4-a181e7624e53-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-16-bs-8-br-64-two-step-d3200ec7-ed2c-4987-9cb4-a181e7624e53.json \
  --distributed \
  --retries 3
