#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-2-bs-16-br-32-a6515dbd-9857-427a-a717-17cbc67ab144-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-2-bs-16-br-32-a6515dbd-9857-427a-a717-17cbc67ab144-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan \
  --config_filepath configs/lines-gan-imagenet-64x64-2-bs-16-br-32-a6515dbd-9857-427a-a717-17cbc67ab144.json \
  --distributed \
  --retries 3
