#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-4-bs-16-br-32-conditional-disc-resume-ema-51b088a3-2d83-4d55-8e06-31a7a621f4ba-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-4-bs-16-br-32-conditional-disc-resume-ema-51b088a3-2d83-4d55-8e06-31a7a621f4ba-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-4-bs-16-br-32-conditional-disc-resume-ema-51b088a3-2d83-4d55-8e06-31a7a621f4ba.json \
  --distributed \
  --retries 3
