#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-7-bs-16-br-32-45bb5a60-f54c-47ee-8b88-f59ce545dbea-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-7-bs-16-br-32-45bb5a60-f54c-47ee-8b88-f59ce545dbea-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate
torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-7-bs-16-br-32-45bb5a60-f54c-47ee-8b88-f59ce545dbea.json \
  --distributed \
  --retries 3
