#!/bin/bash -i
#SBATCH --mem=120g
#SBATCH --cpus-per-task=32
#SBATCH --time=14-0
#SBATCH --gres=gpu:4
#SBATCH --output=runs/outputs/lines-gan-imagenet-64x64-second-phase-10-bs-16-br-128-conditional-disc-ef0f402c-115e-4f8a-be90-45c286e75f63_[0,1,40]-7f6a7d9a-7811-45ad-a682-4df5e74f9b8e-%j.out
#SBATCH --error=runs/errors/lines-gan-imagenet-64x64-second-phase-10-bs-16-br-128-conditional-disc-ef0f402c-115e-4f8a-be90-45c286e75f63_[0,1,40]-7f6a7d9a-7811-45ad-a682-4df5e74f9b8e-%j.err
#SBATCH --mail-user=EMAIL
#SBATCH --mail-type=ALL

module load cuda
module load cudnn
cd PATH
source PATH/bin/activate

PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True torchrun \
  --nproc-per-node 4 \
  -m src.scripts.lines_gan_conditional \
  --config_filepath configs/lines-gan-imagenet-64x64-second-phase-10-bs-16-br-128-conditional-disc-ef0f402c-115e-4f8a-be90-45c286e75f63_\[0,1,40\]-7f6a7d9a-7811-45ad-a682-4df5e74f9b8e.json \
  --distributed \
  --retries 3
