from typing import Optional

from pydantic import BaseModel, Field, ConfigDict


class CheckpointConfig(BaseModel):
    model_config: ConfigDict = ConfigDict(frozen=True, strict=True, validate_assignment=True, extra='forbid')
    folder: str = Field(default='checkpoints')
    save_steps: Optional[int] = Field(default=None)
    last_steps: Optional[int] = Field(default=None)
