from pydantic import BaseModel, Field, ConfigDict


class EDMSchedulerConfig(BaseModel):
    model_config: ConfigDict = ConfigDict(frozen=True, strict=True, validate_assignment=True, extra='forbid')
    sigma_min: float = Field(default=0.002)
    sigma_max: float = Field(default=80.0)
    sigma_data: float = Field(default=0.5)
    rho: float = Field(default=7.0)
