from typing import Optional

from pydantic import BaseModel, ConfigDict, Field


class FIDConfig(BaseModel):
    model_config: ConfigDict = ConfigDict(frozen=True, strict=True, validate_assignment=True, extra='forbid')
    steps: Optional[int] = Field(default=None)
    batch_size: int = Field(default=50)
    dims: int = Field(default=2048)
    reference_path: str = Field()
