from typing import Optional

from pydantic import BaseModel, ConfigDict, Field


class ReportConfig(BaseModel):
    model_config: ConfigDict = ConfigDict(frozen=True, strict=True, validate_assignment=True, extra='forbid')
    train_steps: Optional[int] = Field(default=None)
    test_steps: Optional[int] = Field(default=None)
    log_images_steps: Optional[int] = Field(default=None)
