from .metric import Metric


class AverageMetric(Metric):
    def __init__(self) -> None:
        self.sum: float = 0
        self.n_values: int = 0

    def add(self, value: float) -> None:
        self.sum += value
        self.n_values += 1

    def get_value(self) -> float:
        return self.sum / self.n_values

    def reset(self) -> float:
        value: float = self.get_value()
        self.__init__()
        return value
