from abc import ABC, abstractmethod


class Metric(ABC):
    @abstractmethod
    def add(self, value: float) -> None:
        raise NotImplementedError()

    @abstractmethod
    def get_value(self) -> float:
        raise NotImplementedError()

    @abstractmethod
    def reset(self) -> float:
        raise NotImplementedError()
