import numpy as np


def get_sigmas(
        num_steps: int,
        sigma_min: float = 0.002,
        sigma_max: float = 80.0,
        rho: float = 7.0
) -> np.ndarray:
    indices: np.ndarray = np.arange(num_steps).astype(float)
    sigmas: np.ndarray = np.zeros(num_steps + 1).astype(float)
    sigmas[:num_steps] = \
        (sigma_max ** (1 / rho) + indices / (num_steps - 1) *
         (sigma_min ** (1 / rho) - sigma_max ** (1 / rho))) ** rho
    return sigmas
