import torch


def get_default_device() -> str:
    return 'cuda' if torch.cuda.is_available() else 'cpu'


def params_and_buffers(module: torch.nn.Module) -> list[torch.Tensor]:
    assert isinstance(module, torch.nn.Module)
    return list(module.parameters()) + list(module.buffers())


def named_params_and_buffers(module: torch.nn.Module) -> list[tuple[str, torch.Tensor]]:
    assert isinstance(module, torch.nn.Module)
    return list(module.named_parameters()) + list(module.named_buffers())
