from .utils import get_object_name
from .types import JSON


class BaseObject:
    @property
    def class_name(self) -> str:
        return get_object_name(self)

    def get_json(self) -> dict[str, JSON]:
        return {
            '__class__': self.class_name
        }

    def __repr__(self) -> str:
        return str(self.get_json())
